<?php
use Carbon_Fields\Container;
use Carbon_Fields\Field;

add_action( 'carbon_fields_register_fields', 'lang_translate' );
function lang_translate() {
    $hreflangConfig = [
        'uk-UA' => 'uk-UA',
		'uk-PL' => 'uk-PL',
        'uk-EN' => 'uk-EN',
        'ru-UA' => 'ru-UA',
        'x-default' => 'x-default'
    ];
    Container::make( 'post_meta', 'Lang translate' )
        ->show_on_post_type(array('page', 'game', 'post'))
        ->add_fields( array(
             Field::make( 'complex', 'lang_translate', 'Lang translate')
                  ->add_fields( array(
                        Field::make( 'select', 'hreflang', 'hreflang' )
                                        ->add_options($hreflangConfig)->set_width( 50 ),
                        Field::make('text', 'link', 'Link on post')->set_width( 50 ),
                     )
                  ),
        ));
}